<?php
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class IgalleryControllerImage extends JControllerForm
{
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask('save_and_next', 'save');
	}
	
	function save($key = null, $urlVar = null)
	{
		$data = $this->input->get('jform', array(), 'array');
        foreach($data as $key => $value)
        {
            if(!is_array($data[$key]))
            {
                $data[$key] = JComponentHelper::filterText($value);
            }
        }
		$id = (int)$data['id'];
			
		if(!igGeneralHelper::authorise('core.edit', null, $id))
		{
			$this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}
		
		$model = $this->getModel();
		
		$nextOrder = $model->save($data);
		if($nextOrder === false)
        {
            $this->setRedirect( JRoute::_('index.php?option=com_igallery&view=image&id='.$id, false),$model->getError() );
            return true;
        }
		
		switch($this->task)
		{
			case 'apply':
			$url = 'index.php?option=com_igallery&view=image&id='.$id;
			break;
			
			case 'save_and_next':
			$url = empty($nextOrder) ? $url = 'index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT') : 'index.php?option=com_igallery&view=image&id='.$nextOrder;
			break;
			
			case 'save':
			$url = 'index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT');
		}
		
		$this->setRedirect( JRoute::_($url, false), JText::_('SUCCESSFULLY_SAVED'));
	}

    function addvideo()
    {
        if(!igGeneralHelper::authorise('core.create', $this->input->get('catid',0,'INT') ) )
        {
            echo JText::_('JERROR_ALERTNOAUTHOR');
            return false;
        }

        $videoUrl = $this->input->get('addvideo_url','','HTML');

        if(!$fileData = igFileHelper::processVideoUrl($videoUrl) )
        {
            return false;
        }

        $model = $this->getModel();

        if (!$model->store($fileData) )
        {
            return false;
        }

        $url = 'index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT');
        $this->setRedirect( JRoute::_($url, false), JText::_('SUCCESSFULLY_SAVED'));
    }
	
	function cancel($key = null)
	{
		$this->setRedirect( JRoute::_('index.php?option=com_igallery&view=images&catid='.$this->input->get('catid',0,'INT'), false) );
	}
}