<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class igalleryControllerMigrate extends JControllerAdmin
{
    function migrate()
    {
        if( !igGeneralHelper::authorise('core.edit'))
        {
            echo JText::_('JERROR_ALERTNOAUTHOR');
            return false;
        }

        $db	= JFactory::getDBO();
        $query = 'SELECT * FROM #__igallery_img WHERE filesys = 0 ORDER BY id LIMIT 100';
        $db->setQuery($query);
        $images = $db->loadObjectList();

        $fileNamesInGallery = array();

        foreach($images as $image)
        {
            $rename = false;

            if($image->gallery_id != 0 && !empty($image->filename))
            {
                if( !isset($fileNamesInGallery[$image->gallery_id]) )
                {
                    $fileNamesInGallery[$image->gallery_id] = $this->getFileNamesGallery($image->gallery_id);
                }

                $increment = igFileHelper::getIncrementFromFilename($image->filename);
                $oldFolderName = igFileHelper::getFolderName($increment);
                $sourcePath = IG_ORIG_PATH.'/'.$oldFolderName.'/'.$image->filename;

                $newFolderName = igFileHelper::checkGalleryFolderExists($image->gallery_id);

                $imgHash = substr($image->filename, 0, strrpos($image->filename, '-') );
                $newFileName = $image->filename;

                if( count( array_keys($fileNamesInGallery[$image->gallery_id], $imgHash) ) < 2)
                {
                    $fileExt = JFile::getExt($image->filename);
                    $newFileName = substr($image->filename, 0, strrpos($image->filename, '-') ).'.'.$fileExt;
                    $rename = true;
                }

                $destPath = IG_ORIG_PATH.'/'.$newFolderName.'/'.$newFileName;

                if(!JFile::exists($destPath))
                {
                    if(!JFile::copy($sourcePath, $destPath))
                    {
                        echo $sourcePath.' -> '.$destPath .' '. 'Error Moving File To Directory';
                        return false;
                    }
                }
            }

            if($rename)
            {
                $query = 'UPDATE #__igallery_img SET filesys = 1, filename = '.$db->Quote($newFileName).' WHERE id = '.(int)$image->id;
            }
            else
            {
                $query = 'UPDATE #__igallery_img SET filesys = 1 WHERE id = '.(int)$image->id;
            }

            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                echo $e->getMessage();
                return false;
            }
        }
        echo 1;
        return true;
    }

    function getFileNamesGallery($galleryId)
    {
        $db	= JFactory::getDBO();
        $query = 'SELECT * FROM #__igallery_img WHERE gallery_id = '.(int)$galleryId;
        $db->setQuery($query);
        $images = $db->loadObjectList();
        $imageNames = array();

        foreach($images as $image)
        {
            $imgHash = $image->filesys == 1 ? JFile::stripExt($image->filename) : substr($image->filename, 0, strrpos($image->filename, '-') );
            $imageNames[] = $imgHash;
        }

        return $imageNames;
    }

    function migrate_menu()
    {
        if( !igGeneralHelper::authorise('core.edit') )
        {
            echo JText::_('JERROR_ALERTNOAUTHOR');
            return false;
        }

        $db	= JFactory::getDBO();
        $query = "SELECT * FROM #__igallery WHERE filesys = 0 AND TRIM(menu_image_filename) <> '' ORDER BY id LIMIT 100";
        $db->setQuery($query);
        $images = $db->loadObjectList();

        foreach($images as $image)
        {
            $increment = igFileHelper::getIncrementFromFilename($image->menu_image_filename);
            $oldFolderName = igFileHelper::getFolderName($increment);
            $sourcePath = IG_ORIG_PATH.'/'.$oldFolderName.'/'.$image->menu_image_filename;

            $newFolderName = igFileHelper::checkGalleryFolderExists($image->id);
            $destPath = IG_ORIG_PATH.'/'.$newFolderName.'/'.$image->menu_image_filename;

            if(!JFile::exists($destPath))
            {
                if(!JFile::copy($sourcePath, $destPath))
                {
                    echo $sourcePath.' -> '.$destPath .' '. 'Error Moving File To Directory';
                    return false;
                }
            }

            $query = 'UPDATE #__igallery SET filesys = 1 WHERE id = '.(int)$image->id;
            $db->setQuery($query);
            try
            {
                $db->execute();
            }
            catch(Exception $e)
            {
                echo $e->getMessage();
                return false;
            }
        }
        echo 1;
        return true;
    }

    function migrate_delete_count()
    {
        $count = $this->migrate_delete(true);
        echo $count;
        return true;
    }

    function migrate_delete($count=false,$doCheck=true)
    {
        if( !igGeneralHelper::authorise('core.edit') )
        {
            echo JText::_('JERROR_ALERTNOAUTHOR');
            return false;
        }

        $folderCount = 0;
        $db	= JFactory::getDBO();

        if($doCheck)
        {
            $query = 'SELECT * FROM #__igallery_img WHERE filesys = 0';
            $db->setQuery($query);
            $images = $db->loadObjectList();
            if(count($images) > 0)
            {
                foreach($images as $image)
                {
                    echo 'error can not delete folders, migrate is not complete on image row ('.$image->filename.') with id:'.$image->id;
                }
                return false;
            }
        }


        $catFolderArray = array();
        $query = 'SELECT folder FROM #__igallery';
        $db->setQuery($query);
        $categories = $db->loadObjectList();

        foreach($categories as $category)
        {
            $catFolderArray[] = $category->folder;
        }

        $origFolders = JFolder::folders(IG_ORIG_PATH);

        foreach($origFolders as $folder)
        {
            if(!in_array($folder,$catFolderArray))
            {
                $parts = explode('-',$folder);
                if(count($parts) == 2 && ctype_digit($parts[0]) && ctype_digit($parts[1]))
                {
                    if($count==true)
                    {
                        $folderCount++;
                    }
                    else
                    {
                        if(!JFolder::delete(IG_ORIG_PATH.'/'.$folder))
                        {
                            echo IG_ORIG_PATH.'/'.$folder .' '. 'Error Deleting Folder';
                            return false;
                        }
                    }

                }
            }
        }

        $resizedFolders = JFolder::folders(IG_RESIZE_PATH);
        foreach($resizedFolders as $folder)
        {
            if(!in_array($folder,$catFolderArray))
            {
                $parts = explode('-',$folder);
                if(count($parts) == 2 && ctype_digit($parts[0]) && ctype_digit($parts[1]))
                {
                    if($count==true)
                    {
                        $folderCount++;
                    }
                    else
                    {
                        if(!JFolder::delete(IG_RESIZE_PATH.'/'.$folder))
                        {
                            echo IG_RESIZE_PATH.'/'.$folder .' '. 'Error Deleting Folder';
                            return false;
                        }
                    }
                }
            }
        }

        if($count==true)
        {
            return $folderCount;
        }
        else
        {
            echo 1;
            return true;
        }
    }

}