<?php
defined('_JEXEC') or die('Restricted access');

class igMetadataHelper
{
	static function getExifData($sourceFile)
	{
		$exifDescription = '';

		if( !function_exists('exif_read_data') )
		{
			return  $exifDescription;
		}

		$ext = JFile::getExt($sourceFile);

		if( preg_match("/jp/i", $ext) )
		{
			$exifData = exif_read_data($sourceFile);
			$match = false;

			if( isset($exifData['ImageDescription']))
			{
				if(strlen($exifData['ImageDescription']) > 0)
				{
					$exifDescription = $exifData['ImageDescription'];
					$match = true;
				}
			}

			if( isset($exifData['COMPUTED']['UserComment']) && $match==false)
			{
				if(strlen($exifData['COMPUTED']['UserComment']) > 0)
				{
					$exifDescription = $exifData['COMPUTED']['UserComment'];
					$match = true;
				}
			}

			if( isset($exifData['COMMENT'][0]) && $match==false)
			{
				if(strlen($exifData['COMMENT'][0]) > 0)
				{
					$exifDescription = $exifData['COMMENT'][0];
					$match = true;
				}
			}
		}

		$CleanExifDescription = strip_tags($exifDescription);

		if(JComponentHelper::getParams('com_igallery')->get('force-utf-exif-data',0) == 1)
		{
			$CleanExifDescription = utf8_encode($CleanExifDescription);
		}

		return $CleanExifDescription;
	}

	static function getIptcData($sourceFile)
	{
		$iptcDescription = '';
		$size = getimagesize($sourceFile, $info);
		if(isset($info['APP13']))
		{
			$iptc = iptcparse($info['APP13']);
			$match = false;

			if( isset($iptc['2#120'][0]) )
			{
				if( strlen($iptc['2#120'][0]) > 0)
				{
					$iptcDescription = $iptc['2#120'][0];
					$match = true;
				}
			}
		}

		$CleanIptcDescription = strip_tags($iptcDescription);

		if(JComponentHelper::getParams('com_igallery')->get('force-utf-exif-data',0) == 1)
		{
			$CleanIptcDescription = utf8_encode($CleanIptcDescription);
		}

		return $CleanIptcDescription;
	}

	static function getIptcTags($sourceFile)
	{
		$iptcTagsString = '';
		$size = getimagesize($sourceFile, $info);
		if(isset($info['APP13']))
		{
			$iptc = iptcparse($info['APP13']);

			if( isset($iptc['2#025'][0]) )
			{
				if( strlen($iptc['2#025'][0]) > 0)
				{
					for($i=0; $i<count($iptc['2#025']); $i++)
					{
						$iptcTagsString .= $iptc['2#025'][$i];
						if($i<(count($iptc['2#025'])-1)){$iptcTagsString .= ',';}
					}

				}
			}
		}

		$CleanIptcTagsString = strip_tags($iptcTagsString);

		if(JComponentHelper::getParams('com_igallery')->get('force-utf-exif-data',0) == 1)
		{
			$CleanIptcTagsString = utf8_encode($CleanIptcTagsString);
		}

		return $CleanIptcTagsString;
	}

	static function getIptcTitle($sourceFile)
	{
		$iptcTitle = '';
		$size = getimagesize($sourceFile, $info);
		if(isset($info['APP13']))
		{
			$iptc = iptcparse($info['APP13']);
			$match = false;

			if( isset($iptc['2#105'][0]) )
			{
				if( strlen($iptc['2#105'][0]) > 0)
				{
					$iptcTitle = $iptc['2#105'][0];
					$match = true;
				}
			}

			if( isset($iptc['2#005'][0]) && $match == false)
			{
				if( strlen($iptc['2#005'][0]) > 0)
				{
					$iptcTitle = $iptc['2#005'][0];
					$match = true;
				}
			}
		}

		$CleanIptcTitle = strip_tags($iptcTitle);
		if(JComponentHelper::getParams('com_igallery')->get('force-utf-exif-data',0) == 1)
		{
			$CleanIptcTitle = utf8_encode($CleanIptcTitle);
		}

		return $CleanIptcTitle;
	}

    static function getExifExtra($sourceFile)
    {
		$metaData = array();

	    $ext = JFile::getExt($sourceFile);

        if(function_exists('exif_read_data') && preg_match("/jp/i", $ext))
        {
            $exifData = @exif_read_data($sourceFile);

	        //exif date
	        $metaData['date'] = '';
            if(!empty($exifData['DateTimeOriginal']) && strpos($exifData['DateTimeOriginal'], '0000') === false)
	        {
		        $mysqlFormat = date('Y-m-d H:i:s', strtotime($exifData['DateTimeOriginal']));
				$metaData['date'] = $mysqlFormat;
			}

	        if(!empty($exifData['DateTime']) && empty($metaData['date']) && strpos($exifData['DateTime'], '0000') === false)
	        {
		        $mysqlFormat = date('Y-m-d H:i:s', strtotime($exifData['DateTime']));
		        $metaData['date'] = $mysqlFormat;
			}

			//gps lat &long
	        if( isset($exifData['GPSLatitude']) && isset($exifData['GPSLatitudeRef']) )
	        {
		        $metaData['gps-latitude'] = self::getGps($exifData['GPSLatitude'], $exifData['GPSLatitudeRef']);
	        }

	        if( isset($exifData['GPSLongitude']) && isset($exifData['GPSLongitudeRef']) )
	        {
		        $metaData['gps-longitude'] = self::getGps($exifData['GPSLongitude'], $exifData['GPSLongitudeRef']);
	        }

            //apeture
            $metaData['aperture'] = !empty($exifData['COMPUTED']['ApertureFNumber']) ? $exifData['COMPUTED']['ApertureFNumber'] : '';//"f/3.4",
            $metaData['aperture'] = !empty($exifData['FNumber']) && empty($metaData['aperture']) ? $exifData['FNumber'] : $metaData['aperture'];//"34/10"
            $metaData['aperture'] = !empty($exifData['ApertureValue']) && empty($metaData['aperture']) ? $exifData['ApertureValue'] : $metaData['aperture'];//"35/10"
	        if(strpos($metaData['aperture'], 'f') !== false)
			{
				$metaData['aperture'] = preg_replace("/[^0-9.]/", "", $metaData['aperture']);
			}
	        else
	        {
				$parts = explode('/',$metaData['aperture']);
				if(count($parts) == 2)
				{
					$parts[0] = (int)$parts[0];
					$parts[1] = (int)$parts[1];
					if($parts[0] != 0 && $parts[1] !=0)
					{
						$metaData['aperture'] = round($parts[0]/$parts[1],1);
					}
				}
	        }

	        //make
	        $metaData['make'] = !empty($exifData['Make']) ? $exifData['Make'] : '';

	        //model
	        $metaData['model'] = !empty($exifData['Model']) ? $exifData['Model'] : '';

	        //iso
	        $metaData['iso'] = !empty($exifData['ISOSpeedRatings']) ? $exifData['ISOSpeedRatings'] : '';//int(140)
	        $metaData['iso'] = !empty($exifData['ISOSpeedRatings'][0]) && empty($metaData['iso']) ? $exifData['ISOSpeedRatings'][0] : $metaData['iso'];//int(1600)

            //exposure
            $metaData['exposure-time'] = !empty($exifData['ExposureTime']) ? $exifData['ExposureTime'] : '';//"1/60"
	        if(strpos($metaData['exposure-time'], '/') !== false)
			{
				$parts = explode('/',$metaData['exposure-time']);
				$decimal = $parts[0]/$parts[1];
				if($decimal != 0)
				{
					$bottomFraction = round(1/$decimal);
					$metaData['exposure-time'] = '1/'.$bottomFraction;
				}

			}

	        //focallength
	        $metaData['focal-length'] = !empty($exifData['FocalLength']) ? $exifData['FocalLength'] : '';//473/100
	        if(strpos($metaData['focal-length'], '/') !== false)
	        {
		        $parts = explode('/',$metaData['focal-length']);
				if($parts[1] != 0)
		        {
			        $metaData['focal-length'] = round($parts[0]/$parts[1],2);
				}
			}
			$metaData['focal-length'] = !empty($exifData['FocalLengthIn35mmFilm']) && empty($metaData['focal-length']) ? $exifData['FocalLengthIn35mmFilm'] : $metaData['focal-length'];//int(52)

	        $exifExtra = '{';
	        $exifExtra .= isset($metaData['make']) && !is_array($metaData['make']) ? '"make": "'.strip_tags($metaData['make']).'"' : '';
	        $exifExtra .= isset($metaData['model']) && !is_array($metaData['model']) ? ',"model": "'.strip_tags($metaData['model']).'"' : '';
	        $exifExtra .= isset($metaData['aperture']) && !is_array($metaData['aperture']) ? ',"aperture": "'.strip_tags($metaData['aperture']).'"' : '';
	        $exifExtra .= isset($metaData['exposure-time']) && !is_array($metaData['exposure-time']) ? ',"exposure-time": "'.strip_tags($metaData['exposure-time']).'"' : '';
	        $exifExtra .= isset($metaData['iso']) && !is_array($metaData['iso']) ? ',"iso": "'.strip_tags($metaData['iso']).'"' : '';
	        $exifExtra .= isset($metaData['focal-length']) && !is_array($metaData['focal-length']) ? ',"focal-length": "'.strip_tags($metaData['focal-length']).'"' : '';
	        $exifExtra .= '}';

	        $metaData['extra'] = $exifExtra;

	        return $metaData;
        }
    }


    static function getGps($coordinate, $hemisphere)
    {
        if (is_string($coordinate))
        {
            $coordinate = array_map("trim", explode(",", $coordinate));
        }
        for ($i=0; $i<3; $i++)
        {
            $part = explode('/', $coordinate[$i]);
            if(count($part) == 1)
            {
                $coordinate[$i] = $part[0];
            }
            else if(count($part) == 2)
            {
                $coordinate[$i] = floatval($part[0])/floatval($part[1]);
            }
            else
            {
                $coordinate[$i] = 0;
            }
        }

        list($degrees, $minutes, $seconds) = $coordinate;
        $sign = ($hemisphere == 'W' || $hemisphere == 'S') ? -1 : 1;
        return $sign * ($degrees + $minutes/60 + $seconds/3600);
    }
}