<?php
defined('_JEXEC') or die('Restricted access');

class igUploadHelper
{
    static function upload_file($fileName, $tmpPath, $uploadError, $destDir, $refresh)
	{
		if( !igUploadHelper::checkFileError($uploadError, $fileName, $refresh) )
		{
		    return false;
		}
		
		if( !igUploadHelper::checkMaxFilesize($tmpPath, $fileName, $refresh) )
		{
		    return false;
		}
		
		if( !igUploadHelper::checkExtension($fileName, $refresh) )
		{
		    return false;
		}

        if(JFile::getExt($fileName) == 'svg')
        {
            if( !igUploadHelper::checkSVG($tmpPath, $refresh) )
            {
                return false;
            }
        }
        else
        {
            if( !igUploadHelper::checkIsImage($tmpPath, $refresh) )
            {
                return false;
            }
        }

		
		$fileNameClean = igUploadHelper::replaceSpecial($fileName);
		
		$fileNameUnique = igUploadHelper::makeUniqueName($destDir, $fileNameClean);
		
		if( !igUploadHelper::moveFile($tmpPath, $destDir, $fileNameUnique, $refresh) )
		{
		    return false;
		}

		return $fileNameUnique;
	}
	
	static function checkFileError($uploadError, $fileName, $refresh)
	{
		if ($uploadError > 0)
		{
			switch ($uploadError)
			{
				case 1:
					igFileHelper::raiseError($fileName . ' The uploaded file exceeds the upload_max_filesize directive in php.ini', $refresh);
					break;

				case 2:
					igFileHelper::raiseError($fileName . ' The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form', $refresh);
					break;

				case 3:
					igFileHelper::raiseError($fileName . ' The uploaded file was only partially uploaded', $refresh);
					break;

				case 4:
					igFileHelper::raiseError($fileName . ' No file was uploaded', $refresh);
					break;
				
				case 6:
					igFileHelper::raiseError($fileName . ' Server is missing a temporary upload folder', $refresh);
					break;
					
				case 7:
					igFileHelper::raiseError($fileName . ' Failed to write file to phps temp upload folder, this may be a problem with your disk space limit', $refresh);
					break;
					
				case 8:
					igFileHelper::raiseError($fileName . ' A PHP extension stopped the file upload', $refresh);
					break;
					
				default:
					igFileHelper::raiseError($fileName . ' Upload Error Code: '.$uploadError, $refresh);
			}
			return false;
		}
		
		return true;
	}
	
	static function checkMaxFilesize($tmpPath, $fileName, $refresh)
	{
	    $params = JComponentHelper::getParams('com_igallery');
	    
		$maxUploadSize = $params->get('max_upload_img', 4000) * 1000;
		$fileSize = filesize($tmpPath);
		
		if ($maxUploadSize < $fileSize)
		{
			igFileHelper::raiseError($fileName .' - '.JText::_( 'Filesize' ).': '.$fileSize/1000 .'KB - '.
			JText::_( 'Maximum Image Upload Size - Kilobytes -' ).': '.$maxUploadSize/1000 .'KB - '. JText::_( 'File To Large - Reduce Filesize Or Change Component Paramaters' ), $refresh);
			return false;
		}
		
		return true;
	}
	
	static function checkExtension($fileName, $refresh, $errorRaise = true)
	{
	    $extAccept = 'jpeg,jpg,png,gif,webp,svg';
		$validFileExts = explode(",", $extAccept);
		$uploadedFileExtension = JFile::getExt($fileName);
		$extOk = false;

		foreach($validFileExts as $key => $value)
		{
			if( preg_match("/$value/i", $uploadedFileExtension ) )
			{
				$extOk = true;
			}
		}

		if ($extOk == false)
		{
			if($errorRaise == true)
			{
                if( empty($uploadedFileExtension) )
                {
                    igFileHelper::raiseError('Error, No file extension detected, please try a different uploader in the component options, or try a different browser', $refresh);
                }
                else
                {
                    igFileHelper::raiseError(JText::_( 'Incorrect Filetype' ). ': '.$uploadedFileExtension.
                    ' '.JText::_( 'ALLOWED' ) .': '. $extAccept, $refresh);
                }
			}
			return false;
		}
		
		return true;
	}
	
	static function checkIsImage($tmpPath, $refresh)
	{
        $imageinfo = getimagesize($tmpPath);

		if( !is_int($imageinfo[0]) || !is_int($imageinfo[1]) )
		{
			igFileHelper::raiseError(JText::_( 'No width or height detected in image file' ), $refresh);
			return false;
		}
		
		return true;
	}

    static function checkSVG($tmpPath, $refresh)
    {
        if(!igGeneralHelper::authorise('core.manage'))
        {
            igFileHelper::raiseError('Error, for security reasons, only administrators are allowed to upload SVG files', $refresh);
            return false;
        }

        return true;
    }
	
	static function replaceSpecial($fileName)
	{
        $transliterator = JComponentHelper::getParams('com_igallery')->get('transliterator', 'joomla');

        $fileExt = JFile::getExt($fileName);
	    $fileNameNoExt = JFile::stripExt($fileName);

	    if(function_exists('transliterator_transliterate') && $transliterator == 'php')
        {
            $fileNameNoExt = transliterator_transliterate('Any-Latin;Latin-ASCII;',$fileNameNoExt);
        }
        else
        {
            $lang = JFactory::getLanguage();
            $fileNameNoExt = $lang->transliterate($fileNameNoExt);
        }

        $fileNameNoExt = preg_replace('/[^A-Za-z0-9.]/', '-', $fileNameNoExt);

		$fileExtLowerCase = strtolower($fileExt);

		$fileName = $fileNameNoExt.'.'.$fileExtLowerCase;
		
		return $fileName; 
	}
	
	static function makeUniqueName($destDir, $fileName)
	{
	    $catId = JFactory::getApplication()->input->get('catid', 0,'INT');
	    $db	= JFactory::getDBO();
		$query = 'SELECT filename FROM #__igallery_img WHERE gallery_id = '.(int)$catId;
		$db->setQuery($query);
		$images = $db->loadObjectList();

		foreach($images as $image)
		{
		    if(JFile::stripExt($image->filename) == JFile::stripExt($fileName))
			{
				$fileExt = JFile::getExt($fileName);
	    		$fileNameNoExt = JFile::stripExt($fileName);

	    		$fileName = $fileNameNoExt.rand(1,20).'.'.$fileExt;
	    		break;
			}
		}

		$fileExt = JFile::getExt($fileName);
	    $fileNameNoExt = JFile::stripExt($fileName);
	    
		if(JFile::exists($destDir.$fileName) )
		{
			$i=1;
			while(JFile::exists($destDir.$fileNameNoExt.$i.'.'.$fileExt) )
			{
				$i++;
			}
			$fileName = $fileNameNoExt.$i.'.'.$fileExt;
		}
		
		return $fileName;
	}
	
	static function moveFile($tmpPath, $destDir, $fileName, $refresh)
	{
        $destPath = $destDir.'/'.$fileName;

		if(!JFile::upload($tmpPath, $destPath))
		{
			igFileHelper::raiseError($tmpPath.' -> '.$destPath .' '. JText::_( 'Error Moving File To Directory' ), $refresh);
			return false;
		}

        if(JFile::getExt($fileName) == 'svg')
        {
            if(!class_exists('enshrined\svgSanitize\Sanitizer'))
            {
                require_once(IG_ADMINISTRATOR_COMPONENT . '/lib/svg-sanitizer/includes.php');
            }

            $sanitizer = new enshrined\svgSanitize\Sanitizer();
            $dirtySVG = file_get_contents($destPath);
            $cleanSVG = $sanitizer->sanitize($dirtySVG);

            if(!JFile::delete($destPath))
            {
                igFileHelper::raiseError('Error Sanatising SVG File, can not (delete)/replace: '.$destPath, $refresh);
                return false;
            }

            if(!JFile::write($destPath, $cleanSVG))
            {
                igFileHelper::raiseError('Error Sanatising SVG File, can not delete/(replace): '.$destPath, $refresh);
                return false;
            }
        }
		
		return true;
	}
}
?>