<?php
defined('_JEXEC') or die('Restricted access');

class com_igalleryInstallerScript
{
    function update($parent)
    {
        define('IG_ADMIN_ROOT', JPATH_ADMINISTRATOR.'/components/com_igallery');
        define('IG_FRONTEND_ROOT', JPATH_SITE.'/components/com_igallery');

        //DELETE OLD FILES PART
        $filesToDelete = array();
        $filesToDelete[] = IG_FRONTEND_ROOT.'/views/category/tmpl/default.php';
        $filesToDelete[] = IG_FRONTEND_ROOT.'/models/image.php';
        $filesToDelete[] = IG_ADMIN_ROOT.'/lib/uploaders/plupload/js/jquery-1.3.2.js';
        $filesToDelete[] = IG_ADMIN_ROOT.'/install.igallery.php';
        $filesToDelete[] = IG_ADMIN_ROOT.'/uninstall.igallery.php';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/css/grey-border-shadow.css';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/css/plain.css';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/js/category_mt13.js';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/js/ignitegallery.js';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/css/lightbox.css';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/css/lib-40.css';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/css/ignitegallery-40.css';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/js/lib-40.js';
        $filesToDelete[] = JPATH_SITE.'/media/com_igallery/js/ignitegallery-40.js';

        for($i=0; $i<count($filesToDelete); $i++)
        {
            if(JFile::exists($filesToDelete[$i]))
            {
                if( !JFile::delete($filesToDelete[$i]) )
                {
                    echo 'The Unused File: '.$filesToDelete[$i]. ' could not be removed,
                    please remove it manually <br />';
                }
            }
        }

        //DELETE OLD FOLDERS PART
        $foldersToDelete = array();
        $foldersToDelete[] = IG_ADMIN_ROOT.'/lib/uploaders/plupload/css';
        $foldersToDelete[] = IG_ADMIN_ROOT.'/lib/uploaders/plupload/img';
        $foldersToDelete[] = IG_ADMIN_ROOT.'/lib/uploaders/plupload/js';
        $foldersToDelete[] = IG_ADMIN_ROOT.'/lib/embed';

        for($i=0; $i<count($foldersToDelete); $i++)
        {
            if(JFolder::exists($foldersToDelete[$i]))
            {
                if( !JFolder::delete($foldersToDelete[$i]) )
                {
                    echo 'The Unused Folder: '.$foldersToDelete[$i]. ' could not be removed,
                    please remove it manually <br />';
                }
            }
        }

        //UPDATE DATABASE
        $db = JFactory::getDBO();
        $queries = array();

        //ADD NEW CATEGORY COLUMNS
        $catColumns = array(
            "moderate" => "INT(1) NOT NULL DEFAULT '1'",
            "publish_up" => "DATETIME NULL DEFAULT NULL",
            "publish_down" => "DATETIME NULL DEFAULT NULL",
            "page_title" => "VARCHAR(255) NOT NULL DEFAULT ''",
            "metadesc" => "TEXT NULL",
            "second_user" => "INT(9) NULL DEFAULT NULL",
            "third_user" => "INT(9) NULL DEFAULT NULL",
            "fourth_user" => "INT(9) NULL DEFAULT NULL",
            "password" => "VARCHAR(255) NOT NULL DEFAULT ''",
            "language" => "VARCHAR(24) NOT NULL DEFAULT '*'",
            "extra_field_1" =>  "TEXT NULL",
            "extra_field_2" =>  "TEXT NULL",
            "extra_field_3" =>  "TEXT NULL",
            "extra_field_4" =>  "TEXT NULL",
            "modified" => "DATETIME NOT NULL DEFAULT '1970-01-01 00:00:00'",
            "folder" => "VARCHAR(255) NOT NULL DEFAULT ''",
            "filesys" => "INT(1) NOT NULL DEFAULT '0'"
        );

        foreach($catColumns as $column => $structure)
        {
            $query = "SHOW COLUMNS FROM `#__igallery` LIKE '".$column."'";
            $db->setQuery($query);
            $db->execute();
            if($db->getNumRows() == 0)
            {
                $queries[] = "ALTER TABLE `#__igallery` ADD `".$column."` ".$structure;
            }
        }

        //ADD NEW IMAGE COLUMNS
        $imgColumns = array(
            "moderate" => "INT(1) NOT NULL DEFAULT '1'",
            "publish_up" => "DATETIME NULL DEFAULT NULL",
            "publish_down" => "DATETIME NULL DEFAULT NULL",
            "crop_position" => "varchar(64) NOT NULL DEFAULT 'center_middle'",
            "embed_code" => "TEXT NULL",
            "extra_field_1" =>  "TEXT NULL",
            "extra_field_2" =>  "TEXT NULL",
            "extra_field_3" =>  "TEXT NULL",
            "extra_field_4" =>  "TEXT NULL",
            "src" => "VARCHAR(255) NOT NULL DEFAULT ''",
            "filesys" => "INT(1) NOT NULL DEFAULT '0'",
	        "exif_date" => "DATETIME NULL DEFAULT NULL",
			"exif_latitude" => "VARCHAR(64) NOT NULL DEFAULT ''",
			"exif_longitude" => "VARCHAR(64) NOT NULL DEFAULT ''",
			"exif_extra" => "VARCHAR(512) NOT NULL DEFAULT ''"
        );

        foreach($imgColumns as $column => $structure)
        {
            $query = "SHOW COLUMNS FROM `#__igallery_img` LIKE '".$column."'";
            $db->setQuery($query);
            $db->execute();
            if($db->getNumRows() == 0)
            {
                $queries[] = "ALTER TABLE `#__igallery_img` ADD `".$column."` ".$structure;
            }
        }

        //ADD NEW PROFILE COLUMNS
        $profileColumns = array(
            "asset_id" => "int(10) NOT NULL DEFAULT '0'",
            "slideshow_position" => "VARCHAR(24) NOT NULL DEFAULT 'below'",
            "lbox_slideshow_position" => "VARCHAR(24) NOT NULL DEFAULT 'below'",
            "show_filename" => "VARCHAR(24) NOT NULL DEFAULT 'none'",
            "lbox_show_filename" => "VARCHAR(24) NOT NULL DEFAULT 'none'",
            "show_numbering" => "INT(1) NOT NULL DEFAULT '0'",
            "lbox_show_numbering" => "INT(1) NOT NULL DEFAULT '0'",
            "show_thumb_info" => "VARCHAR(24) NOT NULL DEFAULT 'none'",
            "lbox_show_thumb_info" => "VARCHAR(24) NOT NULL DEFAULT 'none'",
            "plus_one" => "INT(1) NOT NULL DEFAULT '0'",
            "lbox_plus_one" => "INT(1) NOT NULL DEFAULT '0'",
            "main_image_align_horiz" => "VARCHAR(24) NOT NULL DEFAULT 'center'",
            "main_image_align_vert" => "VARCHAR(24) NOT NULL DEFAULT 'center'",
            "lbox_image_align_horiz" => "VARCHAR(24) NOT NULL DEFAULT 'center'",
            "lbox_image_align_vert" => "VARCHAR(24) NOT NULL DEFAULT 'center'",
            "show_image_count" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "image_ordering" => "VARCHAR( 24 ) NOT NULL DEFAULT 'ordering'",
            "twitter_button" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "lbox_twitter_button" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "access" => "int(2) NOT NULL DEFAULT '1'",
            "menu_access" => "int(2) NOT NULL DEFAULT '1'",
            "show_category_hits" => "int(1) NOT NULL DEFAULT '0'",
            "search_results" => "varchar(24) NOT NULL DEFAULT 'joomla'",
            "show_thumb_arrows" => "INT( 1 ) NOT NULL DEFAULT '1'",
            "lbox_show_thumb_arrows" => "INT( 1 ) NOT NULL DEFAULT '1'",
            "pinterest_button" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "lbox_pinterest_button" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "comments_position" => "VARCHAR( 32 ) NOT NULL DEFAULT 'below'",
            "lbox_comments_position" => "VARCHAR( 32 ) NOT NULL DEFAULT 'right'",
            "show_cat_author" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "show_image_author" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "lbox_show_image_author" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "show_image_hits" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "lbox_show_image_hits" => "INT( 1 ) NOT NULL DEFAULT '0'",
            "lbox_back_color" => "VARCHAR( 32 ) NOT NULL DEFAULT 'black'",
            "lbox_back_custom" => "VARCHAR( 32 ) NOT NULL DEFAULT ''",
            "lbox_back_opacity" => "INT( 4 ) NOT NULL DEFAULT '70'",
            "lbox_front_color" => "VARCHAR( 32 ) NOT NULL DEFAULT 'white'",
            "lbox_front_custom" => "VARCHAR( 32 ) NOT NULL DEFAULT ''",
            "mobile_hide_thumbs" => "INT NOT NULL DEFAULT '0'",
            "mobile_lbox_hide_thumbs" => "INT( 1 ) NOT NULL DEFAULT '1'",
            "menu_image_align" => "VARCHAR( 32 ) NOT NULL DEFAULT 'left'",
            "transition" => "VARCHAR( 48 ) NOT NULL DEFAULT 'slide'",
            "lbox_transition" => "VARCHAR( 48 ) NOT NULL DEFAULT 'slide'",
            "transition_touch" => "VARCHAR(48) NOT NULL DEFAULT 'slide'",
            "lbox_transition_touch" => "VARCHAR(48) NOT NULL DEFAULT 'slide'",
            "menu_grid_type" => "VARCHAR(24) NOT NULL DEFAULT 'by_rows'",
            "thumb_grid_type" => "VARCHAR(24) NOT NULL DEFAULT 'by_columns'",
            "thumb_grid_spacing" => "INT(4) NOT NULL DEFAULT '10'",
            "menu_heading_type" => "VARCHAR(24) NOT NULL DEFAULT 'h3'",
            "lightbox_mobile_disable" => "INT(1) NOT NULL DEFAULT '0'",
            "menu_text_position" => "VARCHAR(24) NOT NULL DEFAULT 'below'",
            "thumb_lazyload" => "INT NOT NULL DEFAULT '50'",
            "menu_hover_effect" => "VARCHAR(48) NOT NULL DEFAULT 'none'",
            "thumb_hover_effect" => "VARCHAR(48) NULL DEFAULT 'none'",
            "lbox_thumb_hover_effect" => "VARCHAR(48) NOT NULL DEFAULT 'none'",
            "thumb_layout" => "VARCHAR(48) NOT NULL DEFAULT 'scroller'",
            "lbox_fullscreen" => "VARCHAR(48) NOT NULL DEFAULT 'none'",
            "menu_grid_spacing" => "INT(4) NOT NULL DEFAULT '10'",
            "cat_title_type" => "VARCHAR(24) NOT NULL DEFAULT 'h2'",
            "lbox_zoom" => "INT(1) NOT NULL DEFAULT '0'",
            "lbox_show_play" => "INT(1) NOT NULL DEFAULT '0'",
            "lbox_play_interval" => "INT(5) NOT NULL DEFAULT '3000'",
            "show_play" => "INT(1) NOT NULL DEFAULT '0'",
            "ken_burns" => "INT(1) NOT NULL DEFAULT '0'",
            "show_tag_filters" => "INT(1) NOT NULL DEFAULT '0'",
            "slideshow_infinite" => "INT NOT NULL DEFAULT '1'",
            "lbox_infinite" => "INT NOT NULL DEFAULT '1'",
            "show_dotnav" => "INT(1) NOT NULL DEFAULT '0'",
            "menu_click" => "VARCHAR(64) NOT NULL DEFAULT 'gallery'",
            "menu_ordering" => "VARCHAR(64) NOT NULL DEFAULT 'ordering'",
	        "show_exif_camera" => "INT(1) NOT NULL DEFAULT '0'",
		    "show_exif_gps" => "INT(1) NOT NULL DEFAULT '0'",
		    "lbox_show_exif_camera" => "INT(1) NOT NULL DEFAULT '0'",
		    "lbox_show_exif_gps" => "INT(1) NOT NULL DEFAULT '0'",
        );

        foreach($profileColumns as $column => $structure)
        {
            $query = "SHOW COLUMNS FROM `#__igallery_profiles` LIKE '".$column."'";
            $db->setQuery($query);
            $db->execute();
            if($db->getNumRows() == 0)
            {
                $queries[] = "ALTER TABLE `#__igallery_profiles` ADD `".$column."` ".$structure;
            }
        }

		//ADD RATINGS TABLE IF NOT PRESENT
        $queries[] = 'CREATE TABLE IF NOT EXISTS `#__igallery_ratings`(
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `image_id` int(11) NOT NULL,
		  `rating` int(1) NOT NULL,
		  `ip` varchar(24) NOT NULL,
		  `user` int(11) NOT NULL,
		  `published` int(1) NOT NULL DEFAULT "1",
		  `date` int(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `image_id` (`image_id`),
		  KEY `published` (`published`)
		)  DEFAULT CHARSET=utf8;';

        //ADD comments TABLE IF NOT PRESENT
        $queries[] = 'CREATE TABLE IF NOT EXISTS `#__igallery_comments`(
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `image_id` int(11) NOT NULL,
		  `comment` text NOT NULL,
		  `ip` varchar(24) NOT NULL,
		  `user` int(11) NOT NULL,
		  `published` int(1) NOT NULL DEFAULT "1",
		  `date` int(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `image_id` (`image_id`),
		  KEY `published` (`published`)
		)  DEFAULT CHARSET=utf8;';

        for($i=0;$i<count($queries); $i++)
        {
            $db->setQuery($queries[$i]);
            $db->execute();
        }


		$query = 'SELECT * FROM #__update_sites WHERE location = "http://www.ignitegallery.com/update/xml/component-update.xml"';
        $db->setQuery($query);
        $row = $db->loadObject();

        if(isset($row->update_site_id))
        {
            $query = 'DELETE FROM #__update_sites WHERE update_site_id = '.(int)$row->update_site_id;
            $db->setQuery($query);
            $db->execute();

            $query = 'DELETE FROM #__update_sites_extensions WHERE update_site_id = '.(int)$row->update_site_id;
            $db->setQuery($query);
            $db->execute();
        }

        $j4Queries = array();
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `watermark_filename` `watermark_filename` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `asset_id` `asset_id` INT(10) NOT NULL DEFAULT '0';";
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `lbox_back_custom` `lbox_back_custom` VARCHAR(32) NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `lbox_front_custom` `lbox_front_custom` VARCHAR(32) NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `menu_image_filename` `menu_image_filename` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `publish_up` `publish_up` DATETIME NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `publish_down` `publish_down` DATETIME NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `second_user` `second_user` INT(9) NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `third_user` `third_user` INT(9) NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `fourth_user` `fourth_user` INT(9) NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `extra_field_1` `extra_field_1` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `extra_field_2` `extra_field_2` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `extra_field_3` `extra_field_3` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `extra_field_4` `extra_field_4` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `description` `description` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `tags` `tags` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `alt_text` `alt_text` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `link` `link` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `publish_up` `publish_up` DATETIME NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `publish_down` `publish_down` DATETIME NULL DEFAULT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `embed_code` `embed_code` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `extra_field_1` `extra_field_1` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `extra_field_2` `extra_field_2` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `extra_field_3` `extra_field_3` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `extra_field_4` `extra_field_4` TEXT NULL;";
	    $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `exif_latitude` `exif_latitude` VARCHAR(64) NOT NULL DEFAULT '';";
	    $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `exif_longitude` `exif_longitude` VARCHAR(64) NOT NULL DEFAULT '';";
	    $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `exif_extra` `exif_extra` VARCHAR(512) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `name` `name` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `alias` `alias` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `profile` `profile` INT(5) NOT NULL DEFAULT '0';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `menu_description` `menu_description` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `gallery_description` `gallery_description` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `user` `user` INT(9) NOT NULL DEFAULT '0';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `page_title` `page_title` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `metadesc` `metadesc` TEXT NULL;";
        $j4Queries[] = "ALTER TABLE `#__igallery` CHANGE `password` `password` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_img` CHANGE `filename` `filename` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `name` `name` VARCHAR(255) NOT NULL DEFAULT '';";
        $j4Queries[] = "ALTER TABLE `#__igallery_profiles` CHANGE `watermark_text` `watermark_text` VARCHAR(255) NOT NULL DEFAULT ''; ";

        for($i=0;$i<count($j4Queries); $i++)
        {
            $db->setQuery($j4Queries[$i]);
            $db->execute();
        }
    }

    function uninstall($parent)
    {
        jimport('joomla.filesystem.file');
        jimport('joomla.filesystem.folder');
        require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/defines.php');

        if ( JFolder::exists(IG_IMAGE_PATH) )
        {
            JFolder::delete(IG_IMAGE_PATH);
        }
    }

    function preflight($type, $parent)
    {
        $db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('manifest_cache');
		$query->from('#__extensions');
		$query->where('element = "com_igallery"');
		$db->setQuery($query);
		$row = $db->loadObject();

		if(isset($row->manifest_cache))
		{
			if(strrpos($row->manifest_cache, '{') !== false && strrpos($row->manifest_cache, '}') !== false)
			{
				$manifestParams = new JRegistry;
				$manifestParams->loadString($row->manifest_cache);
				$lastVersion = $manifestParams->get('version');
                JFactory::getApplication()->input->set('ig_last_version', $lastVersion);
			}
		}

        return true;
    }
}
