<?php
/**
 * @version    $Id: JPEG.php 63 2010-09-29 23:06:01Z mthomsonnz $
 * @package	  GDImage
 * @copyright  2007-2010 Gasper Kozak, Matthew Thomson
 * @license	  GNU Lesser General Public License version 2.1
 */

defined('JPATH_BASE') or die();

class GDImage_Mapper_WEBP
{
    function load($uri)
    {
        return imagecreatefromwebp($uri);
    }

    /**
     * Saves the image to a file
     *
     * @param GDImage_Image $img
     * @param string $uri
     * @param integer $quality
     */
    function save($handle, $uri = null, $quality = 100)
    {
        if($uri)
        {
            if(!imageistruecolor($handle))
            {
                imagepalettetotruecolor($handle);
                imagealphablending($handle, true);
                imagesavealpha($handle, true);
            }

            ob_start();
            imagewebp($handle, null, $quality);
            $imageBuffer = ob_get_contents();
            ob_end_clean();

            JFile::write($uri, $imageBuffer);
        }
        else
        {
            imagewebp($handle, null, $quality);
        }
    }
}

