<?php
defined('_JEXEC') or die('Restricted access');

class igUploadFilepond
{
	static function filepondHeadJs()
	{
		$app = JFactory::getApplication();
        $input = JFactory::getApplication()->input;
        $params = JComponentHelper::getParams('com_igallery');
        $document = JFactory::getDocument();

        $catid = $input->get('catid',0,'INT');
		$Itemid = $input->get('Itemid', null,'INT');
		$ItemIdString = empty($Itemid) ? '' : '&Itemid='.$Itemid;
		$urlExtra = (JFactory::getApplication()->isClient('site') && $app->get('sef', 0) == 1 && $app->get('sef_suffix', 0) == 1) ? '&format=raw' : '';

		$document->addStyleSheet(JURI::root(true).'/media/com_igallery/filepond/filepond.css');
		?><script type="text/javascript" src="<?php echo JURI::root(true).'/media/com_igallery/filepond/filepond.min.js';?>"></script><?php

        $langFile = false;
        $langTag = strtolower( JFactory::getLanguage()->getTag() );
        $langPath = JPATH_SITE.'/media/com_igallery/filepond/locale/'.$langTag.'.js';
        if(JFile::exists($langPath))
        {
            $langFile = true;
            ?><script type="text/javascript" src="<?php echo JURI::root(true).'/media/com_igallery/filepond/locale/'.$langTag.'.js'; ?>"></script><?php
        }
        ?>
<script>

jQuery(function()
{
    FilePond.registerPlugin
    (
        FilePondPluginFileValidateType,
        FilePondPluginImageFilter,
        FilePondPluginImageTransform,
        FilePondPluginImageResize,
        FilePondPluginImageExifOrientation
    );

    <?php if($langFile): ?>
    FilePond.setOptions(labels_lang);
    <?php endif; ?>

    FilePond.setOptions
    ({
        maxFileSize: '50MB',
        acceptedFileTypes: ['image/png','image/jpeg','image/gif','image/webp','image/svg+xml'],
        maxParallelUploads: 1,
        credits: {'':'','':''},
        allowMultiple: true,
        allowRevert: false,
        allowProcess: false,
        allowReorder: true,
        itemInsertLocation: 'after',
        instantUpload: false,

        <?php if($params->get('client_resize', 1) == 1): ?>

        allowImageResize: 'true',
        imageResizeTargetWidth: <?php echo $params->get('client_resize_width', 2200); ?>,
        imageResizeTargetHeight: <?php echo $params->get('client_resize_height', 1500); ?>,
        imageResizeMode: "contain",
        imageResizeUpscale: false,

        imageTransformOutputQualityMode: 'optional',
        imageTransformOutputStripImageHead: false,
        imageTransformClientTransforms: ['resize'],

        <?php else: ?>
        allowImageResize: false,
        allowImageTransform: false,
        <?php endif; ?>

        labelFileProcessingError: (error) => {
            bodyString = jQuery('<div>'+error.body+'</div>').text();
            return 'Upload Error | Server Response Code: ' + error.code + ' | Server Response: ' + bodyString.substring(0, 200);
        },

        server:{
            url: '<?php echo JRoute::_('index.php?option=com_igallery&task=image.filePond&catid='.$catid.'&format=raw',false).$urlExtra; ?>',
            process: {
                onload: (response) => {
                    if(response.trim().length > 2)
                    {
                        if( response.includes('Warning') || response.includes('Deprecated') || response.includes('Notice')  )
                        {
                            jQuery('#ig-metadata-warnings').append('<p>'+response+'</p>');
                        }
                        else
                        {
                            alert('Upload Error, Adjusting the uploader settings in the component options -> upload tab may help, response from server: ' + response);
                            FilePond.destroy(document.querySelector('.filepond'));
                        }

                    }
                },
                onerror: (response) => {
                    responseText =  jQuery(response).text().replace(/\s+/g, " ").trim();

                    if(responseText.length > 5)
                    {
                        alert('Upload Error, Adjusting the uploader settings in the component options -> upload tab may help, response from server: ' + responseText);
                        FilePond.destroy(document.querySelector('.filepond'));
                    }
                }
            }

        },

    });

    const pond = FilePond.create(document.querySelector('.filepond'));
    const pondEl = document.querySelector('.filepond--root');
    pondEl.addEventListener('FilePond:processfile', e =>
    {
        var finished = true;
        pond.getFiles().forEach(function(file)
        {
            if(file.status != 5)
            {
                finished = false;
            }
        });
        if(finished == true)
        {
            window.location = "<?php echo JRoute::_('index.php?option=com_igallery&view=images&catid='.$catid.$ItemIdString ,false); ?>";
        }
    });

    jQuery('#ig-start-filepond').on('click', function(e)
    {
        pond.processFiles();
    });

});
</script>

    <?php
    }
	
	static function filepondHTML()
	{
		?>
        <style>.filepond{max-height:400px;}</style>
        <input type="file" class="filepond" name="file[]">
        <button id="ig-start-filepond" class="btn btn-primary"><?php echo JText::_('IG_START_UPLOAD'); ?></button>
        <div id="ig-metadata-warnings" style="max-height:300px;overflow:auto;"></div>
		<?php
	}
}