<?php
defined('JPATH_BASE') or die;

use Joomla\CMS\Factory;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldIcategory extends JFormField
{
	protected $type = 'Icategory';

	protected function getInput()
	{
        $input = JFactory::getApplication()->input;
        $params = JComponentHelper::getParams('com_igallery');

	    require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/helpers/tree.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/helpers/static.php');
		$option = $input->get('option','com_igallery','CMD');
        $hideCurrent = false;
        $multiple = '';

		if($option == 'com_config')
		{
			$selected = $params->get('default_parent', 0);
		}
		else if($option == 'com_menus')
		{
			$selected = $this->value;
		}
		else if(strpos($option, 'module') )
		{
			$igparams = $this->form->getValue('params');
			$selected = isset($igparams->category_id) ? $igparams->category_id : 0;
		}
		else
		{
			$selected = $this->form->getValue('parent');
			$hideCurrent = true;
		} 
		
		$categories = igStaticHelper::getCategories();
        $categoriesbyTree = igTreeHelper::makeCategoryTree($categories);

        if($hideCurrent)
        {
            $current = $input->get('id',0,'INT');
            $categoriesbyTree = igTreeHelper::removeFromTree($categoriesbyTree, 'id', $current, 'numeric-exist');
        }

        if($option == 'com_igallery' && $input->get('view') == 'icategory' && $input->get('id', 0,'INT') > 0 )
        {
            $children = igTreeHelper::getChildIds($categories, $input->get('id', 0,'INT'), true);

            if( count($children) > 0)
            {
                foreach($children as $child)
                {
                    $categoriesbyTree = igTreeHelper::removeFromTree($categoriesbyTree, 'id', $child, 'numeric-exist');
                }
            }
        }

        if($input->get('view') == 'editorbutton' || strpos($option, 'module') )
        {
            $multiple = ' multiple="multiple"';
            $this->name = $this->name.'[]';
        }

	    $selectItems = array();

        if(JFactory::getApplication()->isClient('site'))
        {
            $idsToRemove = array();
            $idsAlwaysShow = trim($params->get('frontend-parent-ids-always-show', '')) == '' ? array() : array_map('intval', explode(',', $params->get('frontend-parent-ids-always-show', '')));
            $levelsToHide = trim($params->get('frontend-parent-hide-levels', '')) == '' ? array() : array_map('intval', explode(',', $params->get('frontend-parent-hide-levels', '')));
            foreach ($categoriesbyTree as $category)
            {
                if($params->get('frontend-parent-hide-uneditable', 0) == 1 && !in_array($category->id,$idsAlwaysShow))
                {
                    if(!igGeneralHelper::authorise('core.igalleryfront.edit', $category->id))
                    {
                        $idsToRemove[] = $category->id;
                    }
                }

                if(in_array($category->level,$levelsToHide) && !in_array($category->id,$idsAlwaysShow))
                {
                    $idsToRemove[] = $category->id;
                }
            }

            foreach($idsToRemove as $id)
            {
                $categoriesbyTree = igTreeHelper::removeFromTree($categoriesbyTree, 'id', $id, 'numeric-exist');
            }
        }


	    if($option != 'com_menus' && !strpos($option, 'module') && $input->get('view') != 'editorbutton')
	    {
            if( JFactory::getApplication()->isClient('site') && $params->get('frontend-parent-show-top', 1) == 0)
            {

            }
            else
            {
                $selectItems[]   = JHTML::_('select.option', '0', JText::_('JGLOBAL_TOP') );
            }
        }

	    foreach ($categoriesbyTree as $category)
	    {
            $displayName = $category->name;
            for($k=0; $k<$category->level; $k++)
            {
                $displayName  = ' - '.$displayName;
            }
	        $selectItems[] = JHTML::_('select.option', $category->id, $displayName );
	    }
		
	    $selectHTML = JHTML::_("select.genericlist", $selectItems, $this->name, 'class="inputbox form-select" '.$multiple,
	    'value', 'text', $selected);

		$igJVersion = new JVersion();
		if($igJVersion::MAJOR_VERSION == 4)
		{
			Factory::getApplication()->getDocument()->getWebAssetManager()->usePreset('choicesjs')->useScript('webcomponent.field-fancy-select');
			$selectHTML = '<joomla-field-fancy-select>'.$selectHTML.'</joomla-field-fancy-select>';
		}

        $linkHtml = '<a href="https://www.ignitegallery.com/documentation/common-questions/133-how-do-i-manage-extra-fields" target="_blank">this page</a>';
        JHtml::_('jquery.framework');
        $js = "
        <script>
        jQuery(document).ready(function($)
        {
            if( $('#jform_params_module_gallery_type').length)
            {
                if($('#jform_params_module_gallery_type').find('option:selected').val() == 'tags_cloud')
                {
                    $('#jform_params_category_id-lbl, #jformparamscategory_id_chzn, #jform_params_ig_children-lbl, #jform_params_ig_children, #jform_params_add_links-lbl, #jform_params_add_links, #jform_params_profile_id-lbl, #jformparamsprofile_id_chzn, #jform_params_ig_tag-lbl, #jform_params_ig_tag, #jform_params_ig_photo_limit-lbl, #jform_params_ig_photo_limit').css('display','none');
                }
        
                $('#jform_params_module_gallery_type').change(function()
                {
                    var val = $(this).find('option:selected').val();
                    if(val == 'tags_cloud')
                    {
                        $('#jform_params_category_id-lbl, #jformparamscategory_id_chzn, #jform_params_ig_children-lbl, #jform_params_ig_children, #jform_params_add_links-lbl, #jform_params_add_links, #jform_params_profile_id-lbl, #jformparamsprofile_id_chzn, #jform_params_ig_tag-lbl, #jform_params_ig_tag, #jform_params_ig_photo_limit-lbl, #jform_params_ig_photo_limit').css('display','none');
                    }
                    else
                    {
                        $('#jform_params_category_id-lbl, #jformparamscategory_id_chzn, #jform_params_ig_children-lbl, #jform_params_ig_children, #jform_params_add_links-lbl, #jform_params_add_links, #jform_params_profile_id-lbl, #jformparamsprofile_id_chzn, #jform_params_ig_tag-lbl, #jform_params_ig_tag, #jform_params_ig_photo_limit-lbl, #jform_params_ig_photo_limit').css('display','block');
                    }
                });
            }
            
            if( $('#jform_show_cat_xtra_1-lbl').length)
            {
                $('#jform_show_cat_xtra_1-lbl').html( $('#jform_show_cat_xtra_1-lbl').html()+' 1');
                $('#jform_show_cat_xtra_2-lbl').html( $('#jform_show_cat_xtra_2-lbl').html()+' 2');
                $('#jform_show_cat_xtra_3-lbl').html( $('#jform_show_cat_xtra_3-lbl').html()+' 3');
                $('#jform_show_cat_xtra_4-lbl').html( $('#jform_show_cat_xtra_4-lbl').html()+' 4');
                
                $('#jform_show_img_xtra_1-lbl').html( $('#jform_show_img_xtra_1-lbl').html()+' 1');
                $('#jform_show_img_xtra_2-lbl').html( $('#jform_show_img_xtra_2-lbl').html()+' 2');
                $('#jform_show_img_xtra_3-lbl').html( $('#jform_show_img_xtra_3-lbl').html()+' 3');
                $('#jform_show_img_xtra_4-lbl').html( $('#jform_show_img_xtra_4-lbl').html()+' 4');
                
            }
            
            if( $('#ig-extra_fields').length)
            {
                  $('#ig-extra_fields').prepend('<p>Please see ".$linkHtml." for extra field instructions.</p><hr />')
            }
            
        });
        </script>";

        $selectHTML = $selectHTML.$js;

        $selectHTML .= "<style>#jform_params_module_gallery_type option:checked{background-color:#ddd!important;}</style>";
        return $selectHTML;
	}
}