<?php
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');


class JFormFieldIprofile extends JFormField
{
	protected $type = 'Iprofile';

	protected function getInput()
	{
        $input = JFactory::getApplication()->input;
	    $option = $input->get('option');
        $params = JComponentHelper::getParams('com_igallery');

		if($option == 'com_config')
		{
			$selected = $params->get('default_profile', 0);
        }
		else if(strpos($option, 'module') )
		{
			$igparams = $this->form->getValue('params');
			$selected = isset($igparams->profile_id) ? $igparams->profile_id : 0;
		}
        else if($option == 'com_menus')
        {
            $selected = $this->value;
        }
		else
		{
			$selected = $this->form->getValue('profile');
		}
		
		$db = JFactory::getDBO();
	    $query = "SELECT id as value, name as text FROM #__igallery_profiles WHERE published = 1 ORDER BY ordering";
	    $db->setQuery( $query );
	    $profiles = $db->loadObjectList();

        if(JFactory::getApplication()->isClient('site'))
        {
            $idsAlwaysShow = trim($params->get('frontend-profile-ids-show', '')) == '' ? array() : array_map('intval', explode(',', $params->get('frontend-profile-ids-show', '')));
            if(!empty($idsAlwaysShow))
            {
                foreach($profiles as $key => $profile)
                {
                    if (!in_array($profile->value, $idsAlwaysShow))
                    {
                        unset($profiles[$key]);
                    }
                }
            }
        }

        $selectHTML = JHTML::_("select.genericlist", $profiles, $this->name, 'class="inputbox form-select"', 'value', 'text', $selected);

        if($option == 'com_config')
        {
            JHtml::_('jquery.framework');
            $selectHTML .= '
<script>
jQuery(document).ready(function($)
{
    $("#component-form").submit(function(e)
    {
        e.preventDefault();
        e.returnValue = false;
        var $form = $(this);
        
        $.ajax({
            url: "'.JURI::root(true).'" + "/administrator/index.php?option=com_igallery&format=raw&task=categories.setSubscriptionId&id=" + $("#jform_subscription_id").val(),
            context: $form,
            complete: function()
            { 
                this.off("submit");
                this.submit();
            }
        });
        
        return true;
        
    });
       
});
</script>
';
        }

        return $selectHTML;
	}
}