<?php
defined('_JEXEC') or die;

jimport( 'joomla.application.component.view');

class igalleryViewcategories extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null)
	{
	    $this->app = JFactory::getApplication();
	    $this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->user         = JFactory::getUser();
		$this->isSite       =  JFactory::getApplication()->isClient('site');
		$this->canConfigure =  igGeneralHelper::authorise('core.admin');
		$this->params = JComponentHelper::getParams('com_igallery');
		$this->moderate = $this->params->get('moderate_cat', 0);

		if (count($errors = $this->get('Errors'))) 
		{
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
		igHtmlHelper::addSubmenu();
        $this->sidebar = JHtmlSidebar::render();
        
        if(JFile::exists(JPATH_PLUGINS.'/system/igallery_img_inserter/igallery_img_inserter.php') )
        {
            JFactory::getApplication()->enqueueMessage('Warning: Please remove the old unused plugin: "System - Ignite Gallery Image Inserter - Version 3.x"');
        }

        if(JFile::exists(JPATH_PLUGINS.'/system/igallery_finder_img/igallery_finder_img.php') && IG_J4)
        {
            JFactory::getApplication()->enqueueMessage('Warning: Please remove the unused plugin: "System - Ignite Gallery Smart Search Image Inserter". You can now choose to show the images in the smart search component options.');
        }

		parent::display($tpl);
	}
	
	protected function addToolbar()
	{
		JToolBarHelper::title( JText::_( 'IGNITE_GALLERY' ).' <small>v'.IG_VERSION_DISPLAY.'</small>', 'generic.png' );
		
		if(igGeneralHelper::authorise('core.create')) 
		{
			JToolBarHelper::custom('categories.add_category_redirect', 'new', '', JText::_( 'NEW_CATEGORY' ), false);
			if($this->isSite == false)
			{
				JToolBarHelper::custom('categories.copy', 'copy', '', JText::_( 'IG_COPY' ) );
			}
		}
		
		if(igGeneralHelper::authorise('core.edit.state')) 
		{
			JToolBarHelper::custom('categories.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			JToolBarHelper::custom('categories.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
		}
		
		if($this->moderate == 1 && $this->isSite == false)
		{
			JToolBarHelper::custom('categories.moderate', 'checkin.png', 'checkin_f2.png', JText::_( 'APPROVE' ) );
			JToolBarHelper::custom('categories.unmoderate', 'remove.png', 'remove_f2.png', JText::_( 'UNAPPROVE' ) );
		}
		
		if(igGeneralHelper::authorise('core.delete')) 
		{
			JToolBarHelper::deleteList(JText::_( 'CONFIRM_DELETE_CATEGORY' ), 'categories.delete','JTOOLBAR_DELETE');
		}

        if(!IG_J4)
        {
            JToolBarHelper::custom('', 'menu', '', JText::_( 'IG_MORE_ACTIONS' ) );
        }
        else
        {
            JToolBarHelper::custom('', 'ellipsis-h', '', JText::_( 'IG_MORE_ACTIONS' ) );
        }

        if(igGeneralHelper::authorise('core.admin') && $this->isSite == false)
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_igallery');
		}
	}
}