<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class igalleryControllerCategories extends JControllerAdmin
{
    public function &getModel($name = 'Icategory', $prefix = 'IgalleryModel', $config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	function delete()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set($this->input->get('formtoken'), 1 );
		
		if(!igGeneralHelper::authorise('core.igalleryfront.delete', (int)$cid[0]))
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_CORE_DELETE_NOT_PERMITTED'));
            return false;
		}

        $model = $this->getModel();
        if($model->delete($cid[0]))
        {
            $this->setMessage(JText::plural($this->text_prefix . '_N_ITEMS_DELETED', count($cid)));
        }
        else
        {
            $this->setMessage($model->getError(), 'error');
        }

        $this->setRedirect(JRoute::_('index.php?option=com_igallery&view=categories&Itemid='.JFactory::getApplication()->input->get('Itemid', '','INT'), false));
	}
	
	function publish()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set($this->input->get('formtoken'), 1 );
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.igalleryfront.edit.state', $cid[$i]))
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}

		parent::publish();
		
	}
	
	function saveorder()
	{
        $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set('cid', $cid);

        $order = $this->input->get('order', array(), 'INT');
        $this->input->post->set('order', $order);

        $this->input->post->set($this->input->get('formtoken'), 1 );
		
		for($i=0; $i<count($cid); $i++)
		{
			if(!igGeneralHelper::authorise('core.igalleryfront.edit.state', $cid[$i]))
			{
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
                return false;
			}
		}
		
		parent::saveorder();
		
	}

	public function reorder()
	{
	    $cid = $this->input->get('cid', array(), 'INT');
        $this->input->post->set('cid', $cid);

        $this->input->post->set($this->input->get('formtoken'), 1 );

		if(!igGeneralHelper::authorise('core.igalleryfront.edit.state', (int)$cid[0]))
		{
            JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
            return false;
		}

		parent::reorder();
	}

    protected function getRedirectToListAppend()
    {
        return '&Itemid='.JFactory::getApplication()->input->get('Itemid', '','INT');
    }
	
	
}