<?php
defined('_JEXEC') or die('Restricted access');

class igUtilityHelper
{
    static function makeImageUrl($url, $imgString)
    {
        if(strpos($url,'?') === false)
        {
            return $url.'?i='.$imgString;
        }
        else
        {
            return $url.'&i='.$imgString;
        }
    }

    static function timeElapsedString($timestamp, $full = false)
    {
        $datetime = date('Y-m-d H:i:s', $timestamp);
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array
        (
            'y' => 'year',
            'm' => 'month',
            'w' => 'week',
            'd' => 'day',
            'h' => 'hour',
            'i' => 'minute',
            's' => 'second',
        );

        foreach($string as $k => &$v)
        {
            if($diff->$k)
            {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            }
            else
            {
                unset($string[$k]);
            }
        }

        if(!$full)
        {
            $string = array_slice($string, 0, 1);
        }

        return $string ? implode(', ', $string) . ' ago' : 'just now';
    }

    static function writeBreadcrumbs($category)
    {
        $app	= JFactory::getApplication();
        $input = $app->input;
        $pathway = $app->getPathway();
        $breadCrumbNames = array();
        $breadCrumbLinks = array();
        $Itemid = $input->get('Itemid', 0,'INT');
        $catIdOfActive = 0;

        if( $Itemid > 0 )
        {
            $menu	= $app->getMenu();
            $activeMenu = $menu->getItem($Itemid);
            if( isset($activeMenu->query['igid']) )
            {
                $catIdOfActive = $activeMenu->query['igid'];
            }
        }

        $categories = igStaticHelper::getCategories();
        $parents = igTreeHelper::getParentPath($categories, $category->id, true);

        foreach($parents as $parent)
        {
            if($parent->id != $catIdOfActive)
            {
                array_unshift($breadCrumbNames, $parent->name);
                if($parent->id != $category->id)
                {
                    array_unshift($breadCrumbLinks, JRoute::_('index.php?option=com_igallery&view=category&igid='.$parent->id.'&Itemid='.JFactory::getApplication()->input->get('Itemid', '','INT') ) );
                }
                else
                {
                    array_unshift($breadCrumbLinks, '');
                }
            }
            else
            {
                break;
            }
        }

        for($i=0; $i<count($breadCrumbNames); $i++)
        {
            $pathway->addItem($breadCrumbNames[$i], $breadCrumbLinks[$i]);
        }
    }

    static function getItemid($catId, $tags=false)
    {
        $app = JFactory::getApplication();
        if(JFactory::getApplication()->isClient('site'))
        {
            $menu = $app->getMenu();
        }
        else
        {
            $menu = JMenu::getInstance('site');
        }

        $menuItems = $menu->getMenu();
        $currentLang = JFactory::getLanguage()->getTag();

        if($tags)
        {
            foreach($menuItems as $menu)
            {
                if($currentLang == $menu->language && $menu->component == 'com_igallery' && $menu->query['view'] == 'tags')
                {
                    return $menu->id;
                }
            }

            foreach($menuItems as $menu)
            {
                if($menu->component == 'com_igallery' && $menu->query['view'] == 'tags')
                {
                    return $menu->id;
                }
            }
        }

        $categories = igStaticHelper::getCategories();
        $parents = igTreeHelper::getParentPath($categories, $catId, false);

        foreach($menuItems as $menu)
        {
            if($currentLang == $menu->language && $menu->component == 'com_igallery' && $menu->query['view'] == 'category' && $menu->query['igid'] == $catId)
            {
                return $menu->id;
            }
        }

        foreach($menuItems as $menu)
        {
            if($menu->component == 'com_igallery' && $menu->query['view'] == 'category' && $menu->query['igid'] == $catId)
            {
                return $menu->id;
            }
        }

        foreach($menuItems as $menu)
        {
            if($currentLang == $menu->language && $menu->component == 'com_igallery' && $menu->query['view'] == 'category')
            {
                foreach($parents as $parent)
                {
                    if($parent->id == $menu->query['igid'])
                    {
                        return $menu->id;
                    }
                }
            }
        }

        foreach($menuItems as $menu)
        {
            if($menu->component == 'com_igallery' && $menu->query['view'] == 'category')
            {
                foreach($parents as $parent)
                {
                    if($parent->id == $menu->query['igid'])
                    {
                        return $menu->id;
                    }
                }
            }
        }

        return $app->input->get('Itemid', 1);
    }

    static function clean($text)
    {
        return htmlentities(strip_tags($text),ENT_QUOTES);
    }

    static function getDescriptionText($textToInsert, $row)
    {
        $displayText = '';

        if($textToInsert == 'full' || $textToInsert == 'full_below')
        {
            preg_match_all('/-[0-9]+/', $row->filename, $matches);
            $displayText = $row->filesys == 0 ? str_replace(end($matches[0]), '', $row->filename) : $row->filename;
            $displayText = str_replace(array('.jpg','.jpeg','.gif','.png'), '', $displayText);
            $displayText = str_replace(array('_','-'),' ',$displayText);
        }

        if($textToInsert == 'alt-text' || $textToInsert == 'alt' || $textToInsert == 'alt_below')
        {
            $displayText = $row->alt_text;
        }

        if($textToInsert == 'description' || $textToInsert == 'description_below')
        {
            $displayText = $row->description;
        }

        return $displayText;
    }

    static function getExtraFieldText($row)
    {
        $params = JComponentHelper::getParams('com_igallery');
        $html = '';

        if(!empty($row->extra_field_1) && $params->get('show_img_xtra_1',0) == 1)
        {
            $value = $params->get('img_xtra_type_1','text') == 'date' ? date("jS F Y",strtotime($row->extra_field_1)) : $row->extra_field_1;
            $html .= '<div class="ig-img-extra-1 ig-img-extra">
            <span class="ig-img-extra-title">'.$params->get('img_xtra_name_1','').':</span> '.
                $value.'</div>';
        }

        if(!empty($row->extra_field_2)  && $params->get('show_img_xtra_2',0) == 1)
        {
            $value = $params->get('img_xtra_type_2','text') == 'date' ? date("jS F Y",strtotime($row->extra_field_2)) : $row->extra_field_2;
            $html .= '<div class="ig-img-extra-2 ig-img-extra">
            <span class="ig-img-extra-title">'.$params->get('img_xtra_name_2','').':</span> '.
                $value.'</div>';
        }

        if(!empty($row->extra_field_3) && $params->get('show_img_xtra_3',0) == 1)
        {
            $value = $params->get('img_xtra_type_3','text') == 'date' ? date("jS F Y",strtotime($row->extra_field_3)) : $row->extra_field_3;
            $html .= '<div class="ig-img-extra-3 ig-img-extra">
            <span class="ig-img-extra-title">'.$params->get('img_xtra_name_3','').':</span> '.
                $value.'</div>';
        }

        if(!empty($row->extra_field_4)  && $params->get('show_img_xtra_4',0) == 1)
        {
            $value = $params->get('img_xtra_type_4','text') == 'date' ? date("jS F Y",strtotime($row->extra_field_4)) : $row->extra_field_4;
            $html .= '<div class="ig-img-extra-4 ig-img-extra">
            <span class="ig-img-extra-title">'.$params->get('img_xtra_name_4','').':</span> '.
                $value.'</div>';
        }

        return $html;
    }

	static function getExifText($showCamera, $showGps, $row)
	{
		if($showCamera == 0 && $showGps == 0){return '';}

		$exifExtra = json_decode($row->exif_extra,true);
		$displayText = '<div class="ig-exif">';

		if($showCamera == 1)
		{
			$displayText .= empty($exifExtra['make']) && empty($exifExtra['model']) ? '' :  '<span class="ig-exif-camera"><span class="ig-exif-title">Camera: </span>'.ucfirst($exifExtra['make']).' '.$exifExtra['model'].'</span>';
			$displayText .= empty($exifExtra['aperture']) ? '' : '<span class="ig-exif-aperture"><span class="ig-exif-title">Aperture: </span>f/'.round((int)$exifExtra['aperture'],1).'</span>';
			$displayText .= empty($exifExtra['exposure-time']) ? '' : '<span class="ig-exif-exposure"><span class="ig-exif-title">Exposure Time: </span>'.$exifExtra['exposure-time'].'</span>';
			$displayText .= empty($exifExtra['iso']) ? '' : '<span class="ig-exif-iso"><span class="ig-exif-title">Iso: </span>'.round((int)$exifExtra['iso']).'</span>';
			$displayText .= empty($exifExtra['focal-length']) ? '' : '<span class="ig-exif-focal"><span class="ig-exif-title">Focal Length: </span>'.round((int)$exifExtra['focal-length'],1).'</span>';
			$displayText .= empty($row->exif_date) ? '' : '<span class="ig-exif-date"><span class="ig-exif-title">Date: </span>'.date("F jS, Y",strtotime($row->exif_date)).'</span>';
		}

		if($showGps == 1)
		{
			$displayText .= empty($row->exif_latitude) && empty($row->exif_longitude) ? '' : '<span class="ig-exif-gps"><a target="_blank" href="https://www.google.com/maps/search/?api=1&query='.$row->exif_latitude.','.$row->exif_longitude.'">GPS Location</a></span>';
		}

		$displayText .= '</div>';

		return $displayText;
	}

    static function shuffleAssoc($list)
    {
        $keys = array_keys($list);
        shuffle($keys);
        $random = array();
        foreach($keys as $key)
        {
            $random[$key] = $list[$key];
        }
        return $random;
    }
}
