<?php
/**
* @package		Ignite Gallery
* @copyright	Copyright (C) 2021 Matthew Thomson. All rights reserved.
* @license		GNU/GPLv2
*/


defined('_JEXEC') or die('Restricted access');
$input = JFactory::getApplication()->input;

$lang = JFactory::getLanguage();
$lang->load('com_igallery', JPATH_ADMINISTRATOR);

jimport('joomla.application.component.controller');
require_once(JPATH_COMPONENT_ADMINISTRATOR.'/defines.php');

jimport('joomla.application.component.model');
JModelLegacy::addIncludePath(IG_ADMINISTRATOR_COMPONENT.'/models');

$task = $input->get('task', 'display');
$view = $input->get('view', 'category');

if( strpos($task,'.') )
{
	$task = substr($task, strpos($task,'.') + 1);
}

$frontendTasks = array('display','addHit','download','addRating','addComment','passwordCheck');
$taskMatch = false;
$frontend = false;

foreach($frontendTasks as $key => $value)
{
	if($value == $task)
	{
		$taskMatch = true;
		break;
	}
}

if($taskMatch == true)
{
	if($task == 'display')
	{
		if($view == 'category' || $view == 'tags')
		{
			$frontend = true;
		}
	}
	else
	{
		$frontend = true;
	}
}

if($frontend == false)
{

	if( JFactory::getUser()->get('guest') )
	{
		JFactory::getApplication()->enqueueMessage('Please login to manage images from the frontend');
		JFactory::getApplication()->redirect('index.php?option=com_users&view=login');
        return true;
	}

	$params = JComponentHelper::getParams('com_igallery');

	if($params->get('allow_frontend_creation', 0) == 0)
	{
		JFactory::getApplication()->enqueueMessage(JText::_('PLEASE_ENABLE_FRONTEND'));
		return false;
	}

	if(!igGeneralHelper::authorise('core.igalleryfront.access'))
	{
		JFactory::getApplication()->enqueueMessage('Please go to the ignite gallery component options -> permissions tab, and set the "Frontend Access" task to allowed for this users group');
		return false;
	}

	JHtml::_('behavior.core');
}

$controller	= JControllerLegacy::getInstance('Igallery', array('default_view'=>'category'));

$controller->execute($task);
$controller->redirect();
?>
