<?php

defined('_JEXEC') or die('Restricted access');

if($params->get('type') == 'tags_cloud')
{
    include_once(JPATH_ADMINISTRATOR.'/components/com_igallery/defines.php');

    $db = JFactory::getDBO();
    $query = $db->getQuery(true);
    $query->select('i.*');
    $query->from('#__igallery_img AS i');
    $query->join('INNER', '`#__igallery` AS c ON c.id = i.gallery_id');
    $query->where('c.published = 1');
    $db->setQuery($query);
    $images = $db->loadObjectList();

    if(empty($images))
    {
        echo 'no published images found';
        return;
    }

    $tagsViewCountArray = array();

    foreach($images as $image)
    {
        $tags = explode(',',strval($image->tags));

        foreach($tags as $tag)
        {
            if(empty($tag)){continue;}

            if(!isset($tagsViewCountArray[$tag]))
            {
                $tagsViewCountArray[$tag] = $image->hits;
            }
            else
            {
                $tagsViewCountArray[$tag] = $tagsViewCountArray[$tag] + $image->hits;
            }
        }
    }

    if(empty($tagsViewCountArray))
    {
        echo 'no image tags found';
        return;
    }

    $maxViews = (int)max($tagsViewCountArray) > 1 ? (int)max($tagsViewCountArray) : 1;
    $minViews = (int)min($tagsViewCountArray);

    $factor = 10/$maxViews;

    $tagsWeighting = array();

    foreach($tagsViewCountArray as $tagName => $tagViews)
    {
        $tagsWeighting[$tagName] = round($factor*$tagViews);
    }

    ?>
    <style>
        .ig-tags-cloud-item-1{font-size: 10px;}
        .ig-tags-cloud-item-2{font-size: 12px;}
        .ig-tags-cloud-item-3{font-size: 14px;}
        .ig-tags-cloud-item-4{font-size: 16px;}
        .ig-tags-cloud-item-5{font-size: 18px;}
        .ig-tags-cloud-item-6{font-size: 20px;}
        .ig-tags-cloud-item-7{font-size: 22px;}
        .ig-tags-cloud-item-8{font-size: 23px;}
        .ig-tags-cloud-item-9{font-size: 24px;}
        .ig-tags-cloud-item-10{font-size: 25px;}

        .ig-tags-cloud-item{
            display: inline-block;
            margin: 3px;
            padding: 5px 15px;
            line-height: 2em;
            transition: color .3s, background-color .3s;
            box-sizing: content-box;
            background-color: #f8f8f8;
            font-weight: normal;
            color: #333333;
            text-decoration: none!important;
        }

        .ig-tags-cloud-item:hover{
            background-color: #d8d8d8;
            color:#666;
        }

        .ig-tags-cloud-item a{
            text-decoration: none!important;
        }
    </style>


    <div class="ig-tags-cloud">
        <?php foreach($tagsWeighting as $tagName => $tagWeight): ?>
            <?php $link = JRoute::_('index.php?option=com_igallery&view=tags&igtags='.trim($tagName).'&Itemid='.igUtilityHelper::getItemid(0,true)); ?><a class="ig-tags-cloud-item ig-tags-cloud-item-<?php echo $tagWeight; ?>" href="<?php echo $link; ?>"><?php echo trim($tagName); ?></a>
        <?php endforeach; ?>
    </div>
<?php
}
else
{
    $igInput = JFactory::getApplication()->input;

    if($igInput->get('format','html') == 'json')
    {
        echo 'Gallery Module '.$module->id;
        return;
    }

    $igInput->set('igsource', 'module');
    $igInput->set('iguniqueid', 'M'.$module->id);
    if(is_array($params->get('category_id')))
    {
        $igInput->set('igid', implode(',',$params->get('category_id')));
    }
    else
    {
        $igInput->set('igid', $params->get('category_id'));
    }
    $igInput->set('igtype', $params->get('type'));
    $igInput->set('igchild', $params->get('children'));
    $igInput->set('igpid', $params->get('profile_id'));
    $igInput->set('igtags', $params->get('tag'));
    $igInput->set('igaddlinks', $params->get('add_links'));

    $photoLimit = $params->get('photo_limit') == 0 ? 150 : $params->get('photo_limit');
    $igInput->set('iglimit', $photoLimit);

    $view = $igInput->get('view',null);
    $layout= $igInput->get('layout',null);

    $igInput->set('view', 'category');
    $igInput->set('layout', 'default');


    $lang = JFactory::getLanguage();
    $lang->load('com_igallery', JPATH_ADMINISTRATOR);

    require_once(JPATH_ADMINISTRATOR.'/components/com_igallery/defines.php');
    require_once(IG_COMPONENT.'/controller.php');

    $controller = new IgalleryController();
    $controller->execute('display');

    if($view != null)
    {
        $igInput->set('view', $view);
    }

    if($layout != null)
    {
        $igInput->set('layout', $layout);
    }

}
?>